// Script assets have changed for v2.3.0 see
// https://help.yoyogames.com/hc/en-us/articles/360005277377 for more information
function scr_initial_conditions(){
	
	Nobj = 3;
	//obj_array[0] = obj_star;
	//obj_array[1] = obj_planet;
	//obj_array[2] = obj_moon;
	
	///////////////////////////////////////////////////
	obj_drag_action[0] = 0;
	obj_drag_action[1] = 0;
	obj_drag_action[2] = 0;
	obj_drag_action[3] = 0;
	
	x_drag_start[0] = 0;
	x_drag_start[1] = 0;
	x_drag_start[2] = 0;
	x_drag_start[3] = 0;
	y_drag_start[0] = 0;
	y_drag_start[1] = 0;
	y_drag_start[2] = 0;
	y_drag_start[3] = 0;
	
	///////////////////////////////////////////////////
	
	G = 4;
	softening = 0.1;
	softening2 = softening*softening;
	dt = 0.01;
	
	central_planet_index = 0;
	
	simulation_run = 0;
	
	x_scale_modifier = 1.9;
	y_scale_modifier = 1.9;
	
	restart_menu_triggered = false;
	
	// Set Objects Masses
	
	star_mass_modificator = 1;
	star_mass = 300000;
	planet_mass_modificator = 1;
	planet_mass = 30000;
	
	mass[0] = star_mass*star_mass_modificator;
	mass[1] = planet_mass*planet_mass_modificator;
	mass[2] = 0.0000000000000000000000000123;
	
	
	// Set Objects initial position and speed within Room
	
	//x_pos[0] = room_width/2;
	//y_pos[0] = room_height/2;
	
	//x_pos[1] = room_width/2;
	//y_pos[1] = room_height/2 + 423.5654;
	
	//x_pos[2] = room_width/2;
	//y_pos[2] = room_height/2 + 423.5654 + 33.1641;
	
	x_pos[0] = 0;
	y_pos[0] = 0;
	
	x_pos[1] = 0;
	y_pos[1] = 229.9467;
	
	x_pos[2] = 0;
	y_pos[2] = 229.9467 + 18.9817;
	
	//obj_array[0].vspeed = 0.0;
	//obj_array[0].hspeed = 0.0;
	
	//obj_array[1].vspeed = 0.0;
	//obj_array[1].hspeed = 63.1074;
	
	//obj_array[2].vspeed = 0.0;
	//obj_array[2].hspeed = 63.1074 + 25.5888;
	
	obj_vspeed[0] = 0.0;
	obj_hspeed[0] = 0.0;
	
	obj_vspeed[1] = 0.0;
	obj_hspeed[1] = 72.2399;
	
	obj_vspeed[2] = 0.0;
	obj_hspeed[2] = 72.2399 + 79.5103;
	
	
	// Set zero initial accelerations
	
	for (var k1 = 0; k1 < Nobj; k1 += 1){
	    v_acc[k1] = 0.0;
		h_acc[k1] = 0.0;
	}
	
	//////////////////////////////
	// Normalize velocities //////
	/////////////////////////////
	
	mean_mass = 0
	mean_vmass = 0;
	mean_hmass = 0;
	for (var i1 = 0; i1 < Nobj; i1 += 1)
	{
		mean_mass += mass[i1];
		mean_vmass += mass[i1]*obj_vspeed[i1];
		mean_hmass += mass[i1]*obj_hspeed[i1];
	}
	mean_mass = mean_mass/Nobj;
	mean_vmass = mean_vmass/Nobj;
	mean_hmass = mean_hmass/Nobj;
	
	for (var i2 = 0; i2 < Nobj; i2 += 1)
	{
		obj_vspeed[i2] -= mean_vmass/mean_mass;
		obj_hspeed[i2] -= mean_hmass/mean_mass;
	}
	
		// Create Sun and Planets and put them in an array
	
	//instance_create_depth(0,0,0,obj_vel);
	
	instance_create_layer(0,0,layer_get_id("Instances"),obj_star);
	instance_create_layer(0,0,layer_get_id("Instances"),obj_planet);
	instance_create_layer(0,0,layer_get_id("Instances"),obj_moon);
	
}